
// We are modularizing this manually because the current modularize setting in Emscripten has some issues:
// https://github.com/kripken/emscripten/issues/5820
// In addition, When you use emcc's modularization, it still expects to export a global object called `Module`,
// which is able to be used/called before the WASM is loaded.
// The modularization below exports a promise that loads and resolves to the actual sql.js module.
// That way, this module can't be used before the WASM is finished loading.

// We are going to define a function that a user will call to start loading initializing our Sql.js library
// However, that function might be called multiple times, and on subsequent calls, we don't actually want it to instantiate a new instance of the Module
// Instead, we want to return the previously loaded module

// TODO: Make this not declare a global if used in the browser
var initSqlJsPromise = undefined;

var initSqlJs = function (moduleConfig) {

    if (initSqlJsPromise){
      return initSqlJsPromise;
    }
    // If we're here, we've never called this function before
    initSqlJsPromise = new Promise(function (resolveModule, reject) {

        // We are modularizing this manually because the current modularize setting in Emscripten has some issues:
        // https://github.com/kripken/emscripten/issues/5820

        // The way to affect the loading of emcc compiled modules is to create a variable called `Module` and add
        // properties to it, like `preRun`, `postRun`, etc
        // We are using that to get notified when the WASM has finished loading.
        // Only then will we return our promise

        // If they passed in a moduleConfig object, use that
        // Otherwise, initialize Module to the empty object
        var Module = typeof moduleConfig !== 'undefined' ? moduleConfig : {};

        // EMCC only allows for a single onAbort function (not an array of functions)
        // So if the user defined their own onAbort function, we remember it and call it
        var originalOnAbortFunction = Module['onAbort'];
        Module['onAbort'] = function (errorThatCausedAbort) {
            reject(new Error(errorThatCausedAbort));
            if (originalOnAbortFunction){
              originalOnAbortFunction(errorThatCausedAbort);
            }
        };

        Module['postRun'] = Module['postRun'] || [];
        Module['postRun'].push(function () {
            // When Emscripted calls postRun, this promise resolves with the built Module
            resolveModule(Module);
        });

        // There is a section of code in the emcc-generated code below that looks like this:
        // (Note that this is lowercase `module`)
        // if (typeof module !== 'undefined') {
        //     module['exports'] = Module;
        // }
        // When that runs, it's going to overwrite our own modularization export efforts in shell-post.js!
        // The only way to tell emcc not to emit it is to pass the MODULARIZE=1 or MODULARIZE_INSTANCE=1 flags,
        // but that carries with it additional unnecessary baggage/bugs we don't want either.
        // So, we have three options:
        // 1) We undefine `module`
        // 2) We remember what `module['exports']` was at the beginning of this function and we restore it later
        // 3) We write a script to remove those lines of code as part of the Make process.
        //
        // Since those are the only lines of code that care about module, we will undefine it. It's the most straightforward
        // of the options, and has the side effect of reducing emcc's efforts to modify the module if its output were to change in the future.
        // That's a nice side effect since we're handling the modularization efforts ourselves
        module = undefined;

        // The emcc-generated code and shell-post.js code goes below,
        // meaning that all of it runs inside of this promise. If anything throws an exception, our promise will abort
var k;k||=typeof Module != 'undefined' ? Module : {};var aa=!!globalThis.window,ba=!!globalThis.WorkerGlobalScope,ca=globalThis.process?.versions?.node&&"renderer"!=globalThis.process?.type;
k.onRuntimeInitialized=function(){function a(f,l){switch(typeof l){case "boolean":dc(f,l?1:0);break;case "number":ec(f,l);break;case "string":fc(f,l,-1,-1);break;case "object":if(null===l)lb(f);else if(null!=l.length){var n=da(l.length);m.set(l,n);gc(f,n,l.length,-1);ea(n)}else sa(f,"Wrong API use : tried to return a value of an unknown type ("+l+").",-1);break;default:lb(f)}}function b(f,l){for(var n=[],p=0;p<f;p+=1){var u=r(l+4*p,"i32"),v=hc(u);if(1===v||2===v)u=ic(u);else if(3===v)u=jc(u);else if(4===
v){v=u;u=kc(v);v=lc(v);for(var K=new Uint8Array(u),I=0;I<u;I+=1)K[I]=m[v+I];u=K}else u=null;n.push(u)}return n}function c(f,l){this.Qa=f;this.db=l;this.Oa=1;this.lb=[]}function d(f,l){this.db=l;this.eb=fa(f);if(null===this.eb)throw Error("Unable to allocate memory for the SQL string");this.kb=this.eb;this.Za=this.qb=null}function e(f){this.filename="dbfile_"+(4294967295*Math.random()>>>0);if(null!=f){var l=this.filename,n="/",p=l;n&&(n="string"==typeof n?n:ha(n),p=l?ia(n+"/"+l):n);l=ja(!0,!0);p=ka(p,
l);if(f){if("string"==typeof f){n=Array(f.length);for(var u=0,v=f.length;u<v;++u)n[u]=f.charCodeAt(u);f=n}la(p,l|146);n=ma(p,577);na(n,f,0,f.length,0);oa(n);la(p,l)}}this.handleError(q(this.filename,g));this.db=r(g,"i32");ob(this.db);this.fb={};this.Sa={}}var g=y(4),h=k.cwrap,q=h("sqlite3_open","number",["string","number"]),w=h("sqlite3_close_v2","number",["number"]),t=h("sqlite3_exec","number",["number","string","number","number","number"]),x=h("sqlite3_changes","number",["number"]),D=h("sqlite3_prepare_v2",
"number",["number","string","number","number","number"]),pb=h("sqlite3_sql","string",["number"]),nc=h("sqlite3_normalized_sql","string",["number"]),qb=h("sqlite3_prepare_v2","number",["number","number","number","number","number"]),oc=h("sqlite3_bind_text","number",["number","number","number","number","number"]),rb=h("sqlite3_bind_blob","number",["number","number","number","number","number"]),pc=h("sqlite3_bind_double","number",["number","number","number"]),qc=h("sqlite3_bind_int","number",["number",
"number","number"]),rc=h("sqlite3_bind_parameter_index","number",["number","string"]),sc=h("sqlite3_step","number",["number"]),tc=h("sqlite3_errmsg","string",["number"]),uc=h("sqlite3_column_count","number",["number"]),vc=h("sqlite3_data_count","number",["number"]),wc=h("sqlite3_column_double","number",["number","number"]),sb=h("sqlite3_column_text","string",["number","number"]),xc=h("sqlite3_column_blob","number",["number","number"]),yc=h("sqlite3_column_bytes","number",["number","number"]),zc=h("sqlite3_column_type",
"number",["number","number"]),Ac=h("sqlite3_column_name","string",["number","number"]),Bc=h("sqlite3_reset","number",["number"]),Cc=h("sqlite3_clear_bindings","number",["number"]),Dc=h("sqlite3_finalize","number",["number"]),tb=h("sqlite3_create_function_v2","number","number string number number number number number number number".split(" ")),hc=h("sqlite3_value_type","number",["number"]),kc=h("sqlite3_value_bytes","number",["number"]),jc=h("sqlite3_value_text","string",["number"]),lc=h("sqlite3_value_blob",
"number",["number"]),ic=h("sqlite3_value_double","number",["number"]),ec=h("sqlite3_result_double","",["number","number"]),lb=h("sqlite3_result_null","",["number"]),fc=h("sqlite3_result_text","",["number","string","number","number"]),gc=h("sqlite3_result_blob","",["number","number","number","number"]),dc=h("sqlite3_result_int","",["number","number"]),sa=h("sqlite3_result_error","",["number","string","number"]),ub=h("sqlite3_aggregate_context","number",["number","number"]),ob=h("RegisterExtensionFunctions",
"number",["number"]),vb=h("sqlite3_update_hook","number",["number","number","number"]);c.prototype.bind=function(f){if(!this.Qa)throw"Statement closed";this.reset();return Array.isArray(f)?this.Cb(f):null!=f&&"object"===typeof f?this.Db(f):!0};c.prototype.step=function(){if(!this.Qa)throw"Statement closed";this.Oa=1;var f=sc(this.Qa);switch(f){case 100:return!0;case 101:return!1;default:throw this.db.handleError(f);}};c.prototype.wb=function(f){null==f&&(f=this.Oa,this.Oa+=1);return wc(this.Qa,f)};
c.prototype.Gb=function(f){null==f&&(f=this.Oa,this.Oa+=1);f=sb(this.Qa,f);if("function"!==typeof BigInt)throw Error("BigInt is not supported");return BigInt(f)};c.prototype.Hb=function(f){null==f&&(f=this.Oa,this.Oa+=1);return sb(this.Qa,f)};c.prototype.getBlob=function(f){null==f&&(f=this.Oa,this.Oa+=1);var l=yc(this.Qa,f);f=xc(this.Qa,f);for(var n=new Uint8Array(l),p=0;p<l;p+=1)n[p]=m[f+p];return n};c.prototype.get=function(f,l){l=l||{};null!=f&&this.bind(f)&&this.step();f=[];for(var n=vc(this.Qa),
p=0;p<n;p+=1)switch(zc(this.Qa,p)){case 1:var u=l.useBigInt?this.Gb(p):this.wb(p);f.push(u);break;case 2:f.push(this.wb(p));break;case 3:f.push(this.Hb(p));break;case 4:f.push(this.getBlob(p));break;default:f.push(null)}return f};c.prototype.getColumnNames=function(){for(var f=[],l=uc(this.Qa),n=0;n<l;n+=1)f.push(Ac(this.Qa,n));return f};c.prototype.getAsObject=function(f,l){f=this.get(f,l);l=this.getColumnNames();for(var n={},p=0;p<l.length;p+=1)n[l[p]]=f[p];return n};c.prototype.getSQL=function(){return pb(this.Qa)};
c.prototype.getNormalizedSQL=function(){return nc(this.Qa)};c.prototype.run=function(f){null!=f&&this.bind(f);this.step();return this.reset()};c.prototype.tb=function(f,l){null==l&&(l=this.Oa,this.Oa+=1);f=fa(f);this.lb.push(f);this.db.handleError(oc(this.Qa,l,f,-1,0))};c.prototype.Bb=function(f,l){null==l&&(l=this.Oa,this.Oa+=1);var n=da(f.length);m.set(f,n);this.lb.push(n);this.db.handleError(rb(this.Qa,l,n,f.length,0))};c.prototype.sb=function(f,l){null==l&&(l=this.Oa,this.Oa+=1);this.db.handleError((f===
(f|0)?qc:pc)(this.Qa,l,f))};c.prototype.Eb=function(f){null==f&&(f=this.Oa,this.Oa+=1);rb(this.Qa,f,0,0,0)};c.prototype.ub=function(f,l){null==l&&(l=this.Oa,this.Oa+=1);switch(typeof f){case "string":this.tb(f,l);return;case "number":this.sb(f,l);return;case "bigint":this.tb(f.toString(),l);return;case "boolean":this.sb(f+0,l);return;case "object":if(null===f){this.Eb(l);return}if(null!=f.length){this.Bb(f,l);return}}throw"Wrong API use : tried to bind a value of an unknown type ("+f+").";};c.prototype.Db=
function(f){var l=this;Object.keys(f).forEach(function(n){var p=rc(l.Qa,n);0!==p&&l.ub(f[n],p)});return!0};c.prototype.Cb=function(f){for(var l=0;l<f.length;l+=1)this.ub(f[l],l+1);return!0};c.prototype.reset=function(){this.freemem();return 0===Cc(this.Qa)&&0===Bc(this.Qa)};c.prototype.freemem=function(){for(var f;void 0!==(f=this.lb.pop());)ea(f)};c.prototype.free=function(){this.freemem();var f=0===Dc(this.Qa);delete this.db.fb[this.Qa];this.Qa=0;return f};d.prototype.next=function(){if(null===
this.eb)return{done:!0};null!==this.Za&&(this.Za.free(),this.Za=null);if(!this.db.db)throw this.nb(),Error("Database closed");var f=pa(),l=y(4);qa(g);qa(l);try{this.db.handleError(qb(this.db.db,this.kb,-1,g,l));this.kb=r(l,"i32");var n=r(g,"i32");if(0===n)return this.nb(),{done:!0};this.Za=new c(n,this.db);this.db.fb[n]=this.Za;return{value:this.Za,done:!1}}catch(p){throw this.qb=z(this.kb),this.nb(),p;}finally{ra(f)}};d.prototype.nb=function(){ea(this.eb);this.eb=null};d.prototype.getRemainingSQL=
function(){return null!==this.qb?this.qb:z(this.kb)};"function"===typeof Symbol&&"symbol"===typeof Symbol.iterator&&(d.prototype[Symbol.iterator]=function(){return this});e.prototype.run=function(f,l){if(!this.db)throw"Database closed";if(l){f=this.prepare(f,l);try{f.step()}finally{f.free()}}else this.handleError(t(this.db,f,0,0,g));return this};e.prototype.exec=function(f,l,n){if(!this.db)throw"Database closed";var p=null,u=null,v=null;try{v=u=fa(f);var K=y(4);for(f=[];0!==r(v,"i8");){qa(g);qa(K);
this.handleError(qb(this.db,v,-1,g,K));var I=r(g,"i32");v=r(K,"i32");if(0!==I){var H=null;p=new c(I,this);for(null!=l&&p.bind(l);p.step();)null===H&&(H={columns:p.getColumnNames(),values:[]},f.push(H)),H.values.push(p.get(null,n));p.free()}}return f}catch(L){throw p&&p.free(),L;}finally{u&&ea(u)}};e.prototype.each=function(f,l,n,p,u){"function"===typeof l&&(p=n,n=l,l=void 0);f=this.prepare(f,l);try{for(;f.step();)n(f.getAsObject(null,u))}finally{f.free()}if("function"===typeof p)return p()};e.prototype.prepare=
function(f,l){qa(g);this.handleError(D(this.db,f,-1,g,0));f=r(g,"i32");if(0===f)throw"Nothing to prepare";var n=new c(f,this);null!=l&&n.bind(l);return this.fb[f]=n};e.prototype.iterateStatements=function(f){return new d(f,this)};e.prototype["export"]=function(){Object.values(this.fb).forEach(function(l){l.free()});Object.values(this.Sa).forEach(A);this.Sa={};this.handleError(w(this.db));var f=ta(this.filename);this.handleError(q(this.filename,g));this.db=r(g,"i32");ob(this.db);return f};e.prototype.close=
function(){null!==this.db&&(Object.values(this.fb).forEach(function(f){f.free()}),Object.values(this.Sa).forEach(A),this.Sa={},this.Ya&&(A(this.Ya),this.Ya=void 0),this.handleError(w(this.db)),ua("/"+this.filename),this.db=null)};e.prototype.handleError=function(f){if(0===f)return null;f=tc(this.db);throw Error(f);};e.prototype.getRowsModified=function(){return x(this.db)};e.prototype.create_function=function(f,l){Object.prototype.hasOwnProperty.call(this.Sa,f)&&(A(this.Sa[f]),delete this.Sa[f]);
var n=va(function(p,u,v){u=b(u,v);try{var K=l.apply(null,u)}catch(I){sa(p,I,-1);return}a(p,K)},"viii");this.Sa[f]=n;this.handleError(tb(this.db,f,l.length,1,0,n,0,0,0));return this};e.prototype.create_aggregate=function(f,l){var n=l.init||function(){return null},p=l.finalize||function(H){return H},u=l.step;if(!u)throw"An aggregate function must have a step function in "+f;var v={};Object.hasOwnProperty.call(this.Sa,f)&&(A(this.Sa[f]),delete this.Sa[f]);l=f+"__finalize";Object.hasOwnProperty.call(this.Sa,
l)&&(A(this.Sa[l]),delete this.Sa[l]);var K=va(function(H,L,Pa){var V=ub(H,1);Object.hasOwnProperty.call(v,V)||(v[V]=n());L=b(L,Pa);L=[v[V]].concat(L);try{v[V]=u.apply(null,L)}catch(Fc){delete v[V],sa(H,Fc,-1)}},"viii"),I=va(function(H){var L=ub(H,1);try{var Pa=p(v[L])}catch(V){delete v[L];sa(H,V,-1);return}a(H,Pa);delete v[L]},"vi");this.Sa[f]=K;this.Sa[l]=I;this.handleError(tb(this.db,f,u.length-1,1,0,0,K,I,0));return this};e.prototype.updateHook=function(f){this.Ya&&(vb(this.db,0,0),A(this.Ya),
this.Ya=void 0);if(!f)return this;this.Ya=va(function(l,n,p,u,v){switch(n){case 18:l="insert";break;case 23:l="update";break;case 9:l="delete";break;default:throw"unknown operationCode in updateHook callback: "+n;}p=z(p);u=z(u);if(v>Number.MAX_SAFE_INTEGER)throw"rowId too big to fit inside a Number";f(l,p,u,Number(v))},"viiiij");vb(this.db,this.Ya,0);return this};k.Database=e};var wa="./this.program",xa=(a,b)=>{throw b;},ya=globalThis.document?.currentScript?.src;
"undefined"!=typeof __filename?ya=__filename:ba&&(ya=self.location.href);var za="",Aa,Ba;
if(ca){var fs=require("node:fs");za=__dirname+"/";Ba=a=>{a=Ca(a)?new URL(a):a;return fs.readFileSync(a)};Aa=async a=>{a=Ca(a)?new URL(a):a;return fs.readFileSync(a,void 0)};1<process.argv.length&&(wa=process.argv[1].replace(/\\/g,"/"));process.argv.slice(2);"undefined"!=typeof module&&(module.exports=k);xa=(a,b)=>{process.exitCode=a;throw b;}}else if(aa||ba){try{za=(new URL(".",ya)).href}catch{}ba&&(Ba=a=>{var b=new XMLHttpRequest;b.open("GET",a,!1);b.responseType="arraybuffer";b.send(null);return new Uint8Array(b.response)});
Aa=async a=>{if(Ca(a))return new Promise((c,d)=>{var e=new XMLHttpRequest;e.open("GET",a,!0);e.responseType="arraybuffer";e.onload=()=>{200==e.status||0==e.status&&e.response?c(e.response):d(e.status)};e.onerror=d;e.send(null)});var b=await fetch(a,{credentials:"same-origin"});if(b.ok)return b.arrayBuffer();throw Error(b.status+" : "+b.url);}}var Da=console.log.bind(console),B=console.error.bind(console),Ea,Fa=!1,Ga,Ca=a=>a.startsWith("file://"),m,C,Ha,E,F,Ia,Ja,G;
function Ka(){var a=La.buffer;m=new Int8Array(a);Ha=new Int16Array(a);C=new Uint8Array(a);new Uint16Array(a);E=new Int32Array(a);F=new Uint32Array(a);Ia=new Float32Array(a);Ja=new Float64Array(a);G=new BigInt64Array(a);new BigUint64Array(a)}function Ma(a){k.onAbort?.(a);a="Aborted("+a+")";B(a);Fa=!0;throw new WebAssembly.RuntimeError(a+". Build with -sASSERTIONS for more info.");}var Na;
async function Oa(a){if(!Ea)try{var b=await Aa(a);return new Uint8Array(b)}catch{}if(a==Na&&Ea)a=new Uint8Array(Ea);else if(Ba)a=Ba(a);else throw"both async and sync fetching of the wasm failed";return a}async function Qa(a,b){try{var c=await Oa(a);return await WebAssembly.instantiate(c,b)}catch(d){B(`failed to asynchronously prepare wasm: ${d}`),Ma(d)}}
async function Ra(a){var b=Na;if(!Ea&&!Ca(b)&&!ca)try{var c=fetch(b,{credentials:"same-origin"});return await WebAssembly.instantiateStreaming(c,a)}catch(d){B(`wasm streaming compile failed: ${d}`),B("falling back to ArrayBuffer instantiation")}return Qa(b,a)}class Sa{name="ExitStatus";constructor(a){this.message=`Program terminated with exit(${a})`;this.status=a}}var Ta=a=>{for(;0<a.length;)a.shift()(k)},Ua=[],Va=[],Wa=()=>{var a=k.preRun.shift();Va.push(a)},J=0,Xa=null;
function r(a,b="i8"){b.endsWith("*")&&(b="*");switch(b){case "i1":return m[a];case "i8":return m[a];case "i16":return Ha[a>>1];case "i32":return E[a>>2];case "i64":return G[a>>3];case "float":return Ia[a>>2];case "double":return Ja[a>>3];case "*":return F[a>>2];default:Ma(`invalid type for getValue: ${b}`)}}var Ya=!0;
function qa(a){var b="i32";b.endsWith("*")&&(b="*");switch(b){case "i1":m[a]=0;break;case "i8":m[a]=0;break;case "i16":Ha[a>>1]=0;break;case "i32":E[a>>2]=0;break;case "i64":G[a>>3]=BigInt(0);break;case "float":Ia[a>>2]=0;break;case "double":Ja[a>>3]=0;break;case "*":F[a>>2]=0;break;default:Ma(`invalid type for setValue: ${b}`)}}
var Za=new TextDecoder,$a=(a,b,c,d)=>{c=b+c;if(d)return c;for(;a[b]&&!(b>=c);)++b;return b},z=(a,b,c)=>a?Za.decode(C.subarray(a,$a(C,a,b,c))):"",ab=(a,b)=>{for(var c=0,d=a.length-1;0<=d;d--){var e=a[d];"."===e?a.splice(d,1):".."===e?(a.splice(d,1),c++):c&&(a.splice(d,1),c--)}if(b)for(;c;c--)a.unshift("..");return a},ia=a=>{var b="/"===a.charAt(0),c="/"===a.slice(-1);(a=ab(a.split("/").filter(d=>!!d),!b).join("/"))||b||(a=".");a&&c&&(a+="/");return(b?"/":"")+a},bb=a=>{var b=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/.exec(a).slice(1);
a=b[0];b=b[1];if(!a&&!b)return".";b&&=b.slice(0,-1);return a+b},cb=a=>a&&a.match(/([^\/]+|\/)\/*$/)[1],db=()=>{if(ca){var a=require("node:crypto");return b=>a.randomFillSync(b)}return b=>crypto.getRandomValues(b)},eb=a=>{(eb=db())(a)},fb=(...a)=>{for(var b="",c=!1,d=a.length-1;-1<=d&&!c;d--){c=0<=d?a[d]:"/";if("string"!=typeof c)throw new TypeError("Arguments to path.resolve must be strings");if(!c)return"";b=c+"/"+b;c="/"===c.charAt(0)}b=ab(b.split("/").filter(e=>!!e),!c).join("/");return(c?"/":
"")+b||"."},gb=a=>{var b=$a(a,0);return Za.decode(a.buffer?a.subarray(0,b):new Uint8Array(a.slice(0,b)))},hb=[],ib=a=>{for(var b=0,c=0;c<a.length;++c){var d=a.charCodeAt(c);127>=d?b++:2047>=d?b+=2:55296<=d&&57343>=d?(b+=4,++c):b+=3}return b},M=(a,b,c,d)=>{if(!(0<d))return 0;var e=c;d=c+d-1;for(var g=0;g<a.length;++g){var h=a.codePointAt(g);if(127>=h){if(c>=d)break;b[c++]=h}else if(2047>=h){if(c+1>=d)break;b[c++]=192|h>>6;b[c++]=128|h&63}else if(65535>=h){if(c+2>=d)break;b[c++]=224|h>>12;b[c++]=128|
h>>6&63;b[c++]=128|h&63}else{if(c+3>=d)break;b[c++]=240|h>>18;b[c++]=128|h>>12&63;b[c++]=128|h>>6&63;b[c++]=128|h&63;g++}}b[c]=0;return c-e},jb=[];function kb(a,b){jb[a]={input:[],output:[],cb:b};mb(a,nb)}
var nb={open(a){var b=jb[a.node.rdev];if(!b)throw new N(43);a.tty=b;a.seekable=!1},close(a){a.tty.cb.fsync(a.tty)},fsync(a){a.tty.cb.fsync(a.tty)},read(a,b,c,d){if(!a.tty||!a.tty.cb.xb)throw new N(60);for(var e=0,g=0;g<d;g++){try{var h=a.tty.cb.xb(a.tty)}catch(q){throw new N(29);}if(void 0===h&&0===e)throw new N(6);if(null===h||void 0===h)break;e++;b[c+g]=h}e&&(a.node.atime=Date.now());return e},write(a,b,c,d){if(!a.tty||!a.tty.cb.rb)throw new N(60);try{for(var e=0;e<d;e++)a.tty.cb.rb(a.tty,b[c+e])}catch(g){throw new N(29);
}d&&(a.node.mtime=a.node.ctime=Date.now());return e}},wb={xb(){a:{if(!hb.length){var a=null;if(ca){var b=Buffer.alloc(256),c=0,d=process.stdin.fd;try{c=fs.readSync(d,b,0,256)}catch(e){if(e.toString().includes("EOF"))c=0;else throw e;}0<c&&(a=b.slice(0,c).toString("utf-8"))}else globalThis.window?.prompt&&(a=window.prompt("Input: "),null!==a&&(a+="\n"));if(!a){a=null;break a}b=Array(ib(a)+1);a=M(a,b,0,b.length);b.length=a;hb=b}a=hb.shift()}return a},rb(a,b){null===b||10===b?(Da(gb(a.output)),a.output=
[]):0!=b&&a.output.push(b)},fsync(a){0<a.output?.length&&(Da(gb(a.output)),a.output=[])},Tb(){return{Ob:25856,Qb:5,Nb:191,Pb:35387,Mb:[3,28,127,21,4,0,1,0,17,19,26,0,18,15,23,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}},Ub(){return 0},Vb(){return[24,80]}},xb={rb(a,b){null===b||10===b?(B(gb(a.output)),a.output=[]):0!=b&&a.output.push(b)},fsync(a){0<a.output?.length&&(B(gb(a.output)),a.output=[])}},O={Wa:null,Xa(){return O.createNode(null,"/",16895,0)},createNode(a,b,c,d){if(24576===(c&61440)||4096===(c&61440))throw new N(63);
O.Wa||(O.Wa={dir:{node:{Ta:O.La.Ta,Ua:O.La.Ua,lookup:O.La.lookup,hb:O.La.hb,rename:O.La.rename,unlink:O.La.unlink,rmdir:O.La.rmdir,readdir:O.La.readdir,symlink:O.La.symlink},stream:{Va:O.Ma.Va}},file:{node:{Ta:O.La.Ta,Ua:O.La.Ua},stream:{Va:O.Ma.Va,read:O.Ma.read,write:O.Ma.write,ib:O.Ma.ib,jb:O.Ma.jb}},link:{node:{Ta:O.La.Ta,Ua:O.La.Ua,readlink:O.La.readlink},stream:{}},vb:{node:{Ta:O.La.Ta,Ua:O.La.Ua},stream:yb}});c=zb(a,b,c,d);P(c.mode)?(c.La=O.Wa.dir.node,c.Ma=O.Wa.dir.stream,c.Na={}):32768===
(c.mode&61440)?(c.La=O.Wa.file.node,c.Ma=O.Wa.file.stream,c.Ra=0,c.Na=null):40960===(c.mode&61440)?(c.La=O.Wa.link.node,c.Ma=O.Wa.link.stream):8192===(c.mode&61440)&&(c.La=O.Wa.vb.node,c.Ma=O.Wa.vb.stream);c.atime=c.mtime=c.ctime=Date.now();a&&(a.Na[b]=c,a.atime=a.mtime=a.ctime=c.atime);return c},Sb(a){return a.Na?a.Na.subarray?a.Na.subarray(0,a.Ra):new Uint8Array(a.Na):new Uint8Array(0)},La:{Ta(a){var b={};b.dev=8192===(a.mode&61440)?a.id:1;b.ino=a.id;b.mode=a.mode;b.nlink=1;b.uid=0;b.gid=0;b.rdev=
a.rdev;P(a.mode)?b.size=4096:32768===(a.mode&61440)?b.size=a.Ra:40960===(a.mode&61440)?b.size=a.link.length:b.size=0;b.atime=new Date(a.atime);b.mtime=new Date(a.mtime);b.ctime=new Date(a.ctime);b.blksize=4096;b.blocks=Math.ceil(b.size/b.blksize);return b},Ua(a,b){for(var c of["mode","atime","mtime","ctime"])null!=b[c]&&(a[c]=b[c]);void 0!==b.size&&(b=b.size,a.Ra!=b&&(0==b?(a.Na=null,a.Ra=0):(c=a.Na,a.Na=new Uint8Array(b),c&&a.Na.set(c.subarray(0,Math.min(b,a.Ra))),a.Ra=b)))},lookup(){O.mb||(O.mb=
new N(44),O.mb.stack="<generic error, no stack>");throw O.mb;},hb(a,b,c,d){return O.createNode(a,b,c,d)},rename(a,b,c){try{var d=Q(b,c)}catch(g){}if(d){if(P(a.mode))for(var e in d.Na)throw new N(55);Ab(d)}delete a.parent.Na[a.name];b.Na[c]=a;a.name=c;b.ctime=b.mtime=a.parent.ctime=a.parent.mtime=Date.now()},unlink(a,b){delete a.Na[b];a.ctime=a.mtime=Date.now()},rmdir(a,b){var c=Q(a,b),d;for(d in c.Na)throw new N(55);delete a.Na[b];a.ctime=a.mtime=Date.now()},readdir(a){return[".","..",...Object.keys(a.Na)]},
symlink(a,b,c){a=O.createNode(a,b,41471,0);a.link=c;return a},readlink(a){if(40960!==(a.mode&61440))throw new N(28);return a.link}},Ma:{read(a,b,c,d,e){var g=a.node.Na;if(e>=a.node.Ra)return 0;a=Math.min(a.node.Ra-e,d);if(8<a&&g.subarray)b.set(g.subarray(e,e+a),c);else for(d=0;d<a;d++)b[c+d]=g[e+d];return a},write(a,b,c,d,e,g){b.buffer===m.buffer&&(g=!1);if(!d)return 0;a=a.node;a.mtime=a.ctime=Date.now();if(b.subarray&&(!a.Na||a.Na.subarray)){if(g)return a.Na=b.subarray(c,c+d),a.Ra=d;if(0===a.Ra&&
0===e)return a.Na=b.slice(c,c+d),a.Ra=d;if(e+d<=a.Ra)return a.Na.set(b.subarray(c,c+d),e),d}g=e+d;var h=a.Na?a.Na.length:0;h>=g||(g=Math.max(g,h*(1048576>h?2:1.125)>>>0),0!=h&&(g=Math.max(g,256)),h=a.Na,a.Na=new Uint8Array(g),0<a.Ra&&a.Na.set(h.subarray(0,a.Ra),0));if(a.Na.subarray&&b.subarray)a.Na.set(b.subarray(c,c+d),e);else for(g=0;g<d;g++)a.Na[e+g]=b[c+g];a.Ra=Math.max(a.Ra,e+d);return d},Va(a,b,c){1===c?b+=a.position:2===c&&32768===(a.node.mode&61440)&&(b+=a.node.Ra);if(0>b)throw new N(28);
return b},ib(a,b,c,d,e){if(32768!==(a.node.mode&61440))throw new N(43);a=a.node.Na;if(e&2||!a||a.buffer!==m.buffer){e=!0;d=65536*Math.ceil(b/65536);var g=Bb(65536,d);g&&C.fill(0,g,g+d);d=g;if(!d)throw new N(48);if(a){if(0<c||c+b<a.length)a.subarray?a=a.subarray(c,c+b):a=Array.prototype.slice.call(a,c,c+b);m.set(a,d)}}else e=!1,d=a.byteOffset;return{Kb:d,Ab:e}},jb(a,b,c,d){O.Ma.write(a,b,0,d,c,!1);return 0}}},ja=(a,b)=>{var c=0;a&&(c|=365);b&&(c|=146);return c},Cb=null,Db={},Eb=[],Fb=1,R=null,Gb=!1,
Hb=!0,Ib={},N=class{name="ErrnoError";constructor(a){this.Pa=a}},Jb=class{gb={};node=null;get flags(){return this.gb.flags}set flags(a){this.gb.flags=a}get position(){return this.gb.position}set position(a){this.gb.position=a}},Kb=class{La={};Ma={};ab=null;constructor(a,b,c,d){a||=this;this.parent=a;this.Xa=a.Xa;this.id=Fb++;this.name=b;this.mode=c;this.rdev=d;this.atime=this.mtime=this.ctime=Date.now()}get read(){return 365===(this.mode&365)}set read(a){a?this.mode|=365:this.mode&=-366}get write(){return 146===
(this.mode&146)}set write(a){a?this.mode|=146:this.mode&=-147}};
function S(a,b={}){if(!a)throw new N(44);b.ob??(b.ob=!0);"/"===a.charAt(0)||(a="//"+a);var c=0;a:for(;40>c;c++){a=a.split("/").filter(q=>!!q);for(var d=Cb,e="/",g=0;g<a.length;g++){var h=g===a.length-1;if(h&&b.parent)break;if("."!==a[g])if(".."===a[g])if(e=bb(e),d===d.parent){a=e+"/"+a.slice(g+1).join("/");c--;continue a}else d=d.parent;else{e=ia(e+"/"+a[g]);try{d=Q(d,a[g])}catch(q){if(44===q?.Pa&&h&&b.Jb)return{path:e};throw q;}!d.ab||h&&!b.ob||(d=d.ab.root);if(40960===(d.mode&61440)&&(!h||b.$a)){if(!d.La.readlink)throw new N(52);
d=d.La.readlink(d);"/"===d.charAt(0)||(d=bb(e)+"/"+d);a=d+"/"+a.slice(g+1).join("/");continue a}}}return{path:e,node:d}}throw new N(32);}function ha(a){for(var b;;){if(a===a.parent)return a=a.Xa.zb,b?"/"!==a[a.length-1]?`${a}/${b}`:a+b:a;b=b?`${a.name}/${b}`:a.name;a=a.parent}}function Lb(a,b){for(var c=0,d=0;d<b.length;d++)c=(c<<5)-c+b.charCodeAt(d)|0;return(a+c>>>0)%R.length}
function Ab(a){var b=Lb(a.parent.id,a.name);if(R[b]===a)R[b]=a.bb;else for(b=R[b];b;){if(b.bb===a){b.bb=a.bb;break}b=b.bb}}function Q(a,b){var c=P(a.mode)?(c=Mb(a,"x"))?c:a.La.lookup?0:2:54;if(c)throw new N(c);for(c=R[Lb(a.id,b)];c;c=c.bb){var d=c.name;if(c.parent.id===a.id&&d===b)return c}return a.La.lookup(a,b)}function zb(a,b,c,d){a=new Kb(a,b,c,d);b=Lb(a.parent.id,a.name);a.bb=R[b];return R[b]=a}function P(a){return 16384===(a&61440)}
function Nb(a){var b=["r","w","rw"][a&3];a&512&&(b+="w");return b}function Mb(a,b){if(Hb)return 0;if(!b.includes("r")||a.mode&292){if(b.includes("w")&&!(a.mode&146)||b.includes("x")&&!(a.mode&73))return 2}else return 2;return 0}function Ob(a,b){if(!P(a.mode))return 54;try{return Q(a,b),20}catch(c){}return Mb(a,"wx")}
function Pb(a,b,c){try{var d=Q(a,b)}catch(e){return e.Pa}if(a=Mb(a,"wx"))return a;if(c){if(!P(d.mode))return 54;if(d===d.parent||"/"===ha(d))return 10}else if(P(d.mode))return 31;return 0}function Qb(a){if(!a)throw new N(63);return a}function T(a){a=Eb[a];if(!a)throw new N(8);return a}function Rb(a,b=-1){a=Object.assign(new Jb,a);if(-1==b)a:{for(b=0;4096>=b;b++)if(!Eb[b])break a;throw new N(33);}a.fd=b;return Eb[b]=a}function Sb(a,b=-1){a=Rb(a,b);a.Ma?.Rb?.(a);return a}
function Tb(a,b,c){var d=a?.Ma.Ua;a=d?a:b;d??=b.La.Ua;Qb(d);d(a,c)}var yb={open(a){a.Ma=Db[a.node.rdev].Ma;a.Ma.open?.(a)},Va(){throw new N(70);}};function mb(a,b){Db[a]={Ma:b}}function Ub(a,b){var c="/"===b;if(c&&Cb)throw new N(10);if(!c&&b){var d=S(b,{ob:!1});b=d.path;d=d.node;if(d.ab)throw new N(10);if(!P(d.mode))throw new N(54);}b={type:a,Wb:{},zb:b,Ib:[]};a=a.Xa(b);a.Xa=b;b.root=a;c?Cb=a:d&&(d.ab=b,d.Xa&&d.Xa.Ib.push(b))}
function Vb(a,b,c){var d=S(a,{parent:!0}).node;a=cb(a);if(!a)throw new N(28);if("."===a||".."===a)throw new N(20);var e=Ob(d,a);if(e)throw new N(e);if(!d.La.hb)throw new N(63);return d.La.hb(d,a,b,c)}function ka(a,b=438){return Vb(a,b&4095|32768,0)}function U(a,b=511){return Vb(a,b&1023|16384,0)}function Wb(a,b,c){"undefined"==typeof c&&(c=b,b=438);Vb(a,b|8192,c)}
function Xb(a,b){if(!fb(a))throw new N(44);var c=S(b,{parent:!0}).node;if(!c)throw new N(44);b=cb(b);var d=Ob(c,b);if(d)throw new N(d);if(!c.La.symlink)throw new N(63);c.La.symlink(c,b,a)}function Yb(a){var b=S(a,{parent:!0}).node;a=cb(a);var c=Q(b,a),d=Pb(b,a,!0);if(d)throw new N(d);if(!b.La.rmdir)throw new N(63);if(c.ab)throw new N(10);b.La.rmdir(b,a);Ab(c)}
function ua(a){var b=S(a,{parent:!0}).node;if(!b)throw new N(44);a=cb(a);var c=Q(b,a),d=Pb(b,a,!1);if(d)throw new N(d);if(!b.La.unlink)throw new N(63);if(c.ab)throw new N(10);b.La.unlink(b,a);Ab(c)}function Zb(a,b){a=S(a,{$a:!b}).node;return Qb(a.La.Ta)(a)}function $b(a,b,c,d){Tb(a,b,{mode:c&4095|b.mode&-4096,ctime:Date.now(),Fb:d})}function la(a,b){a="string"==typeof a?S(a,{$a:!0}).node:a;$b(null,a,b)}
function ac(a,b,c){if(P(b.mode))throw new N(31);if(32768!==(b.mode&61440))throw new N(28);var d=Mb(b,"w");if(d)throw new N(d);Tb(a,b,{size:c,timestamp:Date.now()})}
function ma(a,b,c=438){if(""===a)throw new N(44);if("string"==typeof b){var d={r:0,"r+":2,w:577,"w+":578,a:1089,"a+":1090}[b];if("undefined"==typeof d)throw Error(`Unknown file open mode: ${b}`);b=d}c=b&64?c&4095|32768:0;if("object"==typeof a)d=a;else{var e=a.endsWith("/");a=S(a,{$a:!(b&131072),Jb:!0});d=a.node;a=a.path}var g=!1;if(b&64)if(d){if(b&128)throw new N(20);}else{if(e)throw new N(31);d=Vb(a,c|511,0);g=!0}if(!d)throw new N(44);8192===(d.mode&61440)&&(b&=-513);if(b&65536&&!P(d.mode))throw new N(54);
if(!g&&(e=d?40960===(d.mode&61440)?32:P(d.mode)&&("r"!==Nb(b)||b&576)?31:Mb(d,Nb(b)):44))throw new N(e);b&512&&!g&&(e=d,e="string"==typeof e?S(e,{$a:!0}).node:e,ac(null,e,0));b&=-131713;e=Rb({node:d,path:ha(d),flags:b,seekable:!0,position:0,Ma:d.Ma,Lb:[],error:!1});e.Ma.open&&e.Ma.open(e);g&&la(d,c&511);!k.logReadFiles||b&1||a in Ib||(Ib[a]=1);return e}function oa(a){if(null===a.fd)throw new N(8);a.pb&&(a.pb=null);try{a.Ma.close&&a.Ma.close(a)}catch(b){throw b;}finally{Eb[a.fd]=null}a.fd=null}
function bc(a,b,c){if(null===a.fd)throw new N(8);if(!a.seekable||!a.Ma.Va)throw new N(70);if(0!=c&&1!=c&&2!=c)throw new N(28);a.position=a.Ma.Va(a,b,c);a.Lb=[]}function cc(a,b,c,d,e){if(0>d||0>e)throw new N(28);if(null===a.fd)throw new N(8);if(1===(a.flags&2097155))throw new N(8);if(P(a.node.mode))throw new N(31);if(!a.Ma.read)throw new N(28);var g="undefined"!=typeof e;if(!g)e=a.position;else if(!a.seekable)throw new N(70);b=a.Ma.read(a,b,c,d,e);g||(a.position+=b);return b}
function na(a,b,c,d,e){if(0>d||0>e)throw new N(28);if(null===a.fd)throw new N(8);if(0===(a.flags&2097155))throw new N(8);if(P(a.node.mode))throw new N(31);if(!a.Ma.write)throw new N(28);a.seekable&&a.flags&1024&&bc(a,0,2);var g="undefined"!=typeof e;if(!g)e=a.position;else if(!a.seekable)throw new N(70);b=a.Ma.write(a,b,c,d,e,void 0);g||(a.position+=b);return b}
function ta(a){var b=b||0;var c="binary";"utf8"!==c&&"binary"!==c&&Ma(`Invalid encoding type "${c}"`);b=ma(a,b);a=Zb(a).size;var d=new Uint8Array(a);cc(b,d,0,a,0);"utf8"===c&&(d=gb(d));oa(b);return d}
function W(a,b,c){a=ia("/dev/"+a);var d=ja(!!b,!!c);W.yb??(W.yb=64);var e=W.yb++<<8|0;mb(e,{open(g){g.seekable=!1},close(){c?.buffer?.length&&c(10)},read(g,h,q,w){for(var t=0,x=0;x<w;x++){try{var D=b()}catch(pb){throw new N(29);}if(void 0===D&&0===t)throw new N(6);if(null===D||void 0===D)break;t++;h[q+x]=D}t&&(g.node.atime=Date.now());return t},write(g,h,q,w){for(var t=0;t<w;t++)try{c(h[q+t])}catch(x){throw new N(29);}w&&(g.node.mtime=g.node.ctime=Date.now());return t}});Wb(a,d,e)}var X={};
function Y(a,b,c){if("/"===b.charAt(0))return b;a=-100===a?"/":T(a).path;if(0==b.length){if(!c)throw new N(44);return a}return a+"/"+b}
function mc(a,b){F[a>>2]=b.dev;F[a+4>>2]=b.mode;F[a+8>>2]=b.nlink;F[a+12>>2]=b.uid;F[a+16>>2]=b.gid;F[a+20>>2]=b.rdev;G[a+24>>3]=BigInt(b.size);E[a+32>>2]=4096;E[a+36>>2]=b.blocks;var c=b.atime.getTime(),d=b.mtime.getTime(),e=b.ctime.getTime();G[a+40>>3]=BigInt(Math.floor(c/1E3));F[a+48>>2]=c%1E3*1E6;G[a+56>>3]=BigInt(Math.floor(d/1E3));F[a+64>>2]=d%1E3*1E6;G[a+72>>3]=BigInt(Math.floor(e/1E3));F[a+80>>2]=e%1E3*1E6;G[a+88>>3]=BigInt(b.ino);return 0}
var Ec=void 0,Gc=()=>{var a=E[+Ec>>2];Ec+=4;return a},Hc=0,Ic=[0,31,60,91,121,152,182,213,244,274,305,335],Jc=[0,31,59,90,120,151,181,212,243,273,304,334],Kc={},Lc=a=>{Ga=a;Ya||0<Hc||(k.onExit?.(a),Fa=!0);xa(a,new Sa(a))},Mc=a=>{if(!Fa)try{a()}catch(b){b instanceof Sa||"unwind"==b||xa(1,b)}finally{if(!(Ya||0<Hc))try{Ga=a=Ga,Lc(a)}catch(b){b instanceof Sa||"unwind"==b||xa(1,b)}}},Nc={},Pc=()=>{if(!Oc){var a={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(globalThis.navigator?.language??
"C").replace("-","_")+".UTF-8",_:wa||"./this.program"},b;for(b in Nc)void 0===Nc[b]?delete a[b]:a[b]=Nc[b];var c=[];for(b in a)c.push(`${b}=${a[b]}`);Oc=c}return Oc},Oc,Qc=(a,b,c,d)=>{var e={string:t=>{var x=0;if(null!==t&&void 0!==t&&0!==t){x=ib(t)+1;var D=y(x);M(t,C,D,x);x=D}return x},array:t=>{var x=y(t.length);m.set(t,x);return x}};a=k["_"+a];var g=[],h=0;if(d)for(var q=0;q<d.length;q++){var w=e[c[q]];w?(0===h&&(h=pa()),g[q]=w(d[q])):g[q]=d[q]}c=a(...g);return c=function(t){0!==h&&ra(h);return"string"===
b?z(t):"boolean"===b?!!t:t}(c)},fa=a=>{var b=ib(a)+1,c=da(b);c&&M(a,C,c,b);return c},Rc,Sc=[],A=a=>{Rc.delete(Z.get(a));Z.set(a,null);Sc.push(a)},Tc=a=>{const b=a.length;return[b%128|128,b>>7,...a]},Uc={i:127,p:127,j:126,f:125,d:124,e:111},Vc=a=>Tc(Array.from(a,b=>Uc[b])),va=(a,b)=>{if(!Rc){Rc=new WeakMap;var c=Z.length;if(Rc)for(var d=0;d<0+c;d++){var e=Z.get(d);e&&Rc.set(e,d)}}if(c=Rc.get(a)||0)return c;c=Sc.length?Sc.pop():Z.grow(1);try{Z.set(c,a)}catch(g){if(!(g instanceof TypeError))throw g;
b=Uint8Array.of(0,97,115,109,1,0,0,0,1,...Tc([1,96,...Vc(b.slice(1)),...Vc("v"===b[0]?"":b[0])]),2,7,1,1,101,1,102,0,0,7,5,1,1,102,0,0);b=new WebAssembly.Module(b);b=(new WebAssembly.Instance(b,{e:{f:a}})).exports.f;Z.set(c,b)}Rc.set(a,c);return c};R=Array(4096);Ub(O,"/");U("/tmp");U("/home");U("/home/web_user");
(function(){U("/dev");mb(259,{read:()=>0,write:(d,e,g,h)=>h,Va:()=>0});Wb("/dev/null",259);kb(1280,wb);kb(1536,xb);Wb("/dev/tty",1280);Wb("/dev/tty1",1536);var a=new Uint8Array(1024),b=0,c=()=>{0===b&&(eb(a),b=a.byteLength);return a[--b]};W("random",c);W("urandom",c);U("/dev/shm");U("/dev/shm/tmp")})();
(function(){U("/proc");var a=U("/proc/self");U("/proc/self/fd");Ub({Xa(){var b=zb(a,"fd",16895,73);b.Ma={Va:O.Ma.Va};b.La={lookup(c,d){c=+d;var e=T(c);c={parent:null,Xa:{zb:"fake"},La:{readlink:()=>e.path},id:c+1};return c.parent=c},readdir(){return Array.from(Eb.entries()).filter(([,c])=>c).map(([c])=>c.toString())}};return b}},"/proc/self/fd")})();k.noExitRuntime&&(Ya=k.noExitRuntime);k.print&&(Da=k.print);k.printErr&&(B=k.printErr);k.wasmBinary&&(Ea=k.wasmBinary);k.thisProgram&&(wa=k.thisProgram);
if(k.preInit)for("function"==typeof k.preInit&&(k.preInit=[k.preInit]);0<k.preInit.length;)k.preInit.shift()();k.stackSave=()=>pa();k.stackRestore=a=>ra(a);k.stackAlloc=a=>y(a);k.cwrap=(a,b,c,d)=>{var e=!c||c.every(g=>"number"===g||"boolean"===g);return"string"!==b&&e&&!d?k["_"+a]:(...g)=>Qc(a,b,c,g)};k.addFunction=va;k.removeFunction=A;k.UTF8ToString=z;k.stringToNewUTF8=fa;k.writeArrayToMemory=(a,b)=>{m.set(a,b)};
var da,ea,Bb,Wc,ra,y,pa,La,Z,Xc={a:(a,b,c,d)=>Ma(`Assertion failed: ${z(a)}, at: `+[b?z(b):"unknown filename",c,d?z(d):"unknown function"]),i:function(a,b){try{return a=z(a),la(a,b),0}catch(c){if("undefined"==typeof X||"ErrnoError"!==c.name)throw c;return-c.Pa}},L:function(a,b,c){try{b=z(b);b=Y(a,b);if(c&-8)return-28;var d=S(b,{$a:!0}).node;if(!d)return-44;a="";c&4&&(a+="r");c&2&&(a+="w");c&1&&(a+="x");return a&&Mb(d,a)?-2:0}catch(e){if("undefined"==typeof X||"ErrnoError"!==e.name)throw e;return-e.Pa}},
j:function(a,b){try{var c=T(a);$b(c,c.node,b,!1);return 0}catch(d){if("undefined"==typeof X||"ErrnoError"!==d.name)throw d;return-d.Pa}},h:function(a){try{var b=T(a);Tb(b,b.node,{timestamp:Date.now(),Fb:!1});return 0}catch(c){if("undefined"==typeof X||"ErrnoError"!==c.name)throw c;return-c.Pa}},b:function(a,b,c){Ec=c;try{var d=T(a);switch(b){case 0:var e=Gc();if(0>e)break;for(;Eb[e];)e++;return Sb(d,e).fd;case 1:case 2:return 0;case 3:return d.flags;case 4:return e=Gc(),d.flags|=e,0;case 12:return e=
Gc(),Ha[e+0>>1]=2,0;case 13:case 14:return 0}return-28}catch(g){if("undefined"==typeof X||"ErrnoError"!==g.name)throw g;return-g.Pa}},g:function(a,b){try{var c=T(a),d=c.node,e=c.Ma.Ta;a=e?c:d;e??=d.La.Ta;Qb(e);var g=e(a);return mc(b,g)}catch(h){if("undefined"==typeof X||"ErrnoError"!==h.name)throw h;return-h.Pa}},H:function(a,b){b=-9007199254740992>b||9007199254740992<b?NaN:Number(b);try{if(isNaN(b))return-61;var c=T(a);if(0>b||0===(c.flags&2097155))throw new N(28);ac(c,c.node,b);return 0}catch(d){if("undefined"==
typeof X||"ErrnoError"!==d.name)throw d;return-d.Pa}},G:function(a,b){try{if(0===b)return-28;var c=ib("/")+1;if(b<c)return-68;M("/",C,a,b);return c}catch(d){if("undefined"==typeof X||"ErrnoError"!==d.name)throw d;return-d.Pa}},K:function(a,b){try{return a=z(a),mc(b,Zb(a,!0))}catch(c){if("undefined"==typeof X||"ErrnoError"!==c.name)throw c;return-c.Pa}},C:function(a,b,c){try{return b=z(b),b=Y(a,b),U(b,c),0}catch(d){if("undefined"==typeof X||"ErrnoError"!==d.name)throw d;return-d.Pa}},J:function(a,
b,c,d){try{b=z(b);var e=d&256;b=Y(a,b,d&4096);return mc(c,e?Zb(b,!0):Zb(b))}catch(g){if("undefined"==typeof X||"ErrnoError"!==g.name)throw g;return-g.Pa}},x:function(a,b,c,d){Ec=d;try{b=z(b);b=Y(a,b);var e=d?Gc():0;return ma(b,c,e).fd}catch(g){if("undefined"==typeof X||"ErrnoError"!==g.name)throw g;return-g.Pa}},v:function(a,b,c,d){try{b=z(b);b=Y(a,b);if(0>=d)return-28;var e=S(b).node;if(!e)throw new N(44);if(!e.La.readlink)throw new N(28);var g=e.La.readlink(e);var h=Math.min(d,ib(g)),q=m[c+h];M(g,
C,c,d+1);m[c+h]=q;return h}catch(w){if("undefined"==typeof X||"ErrnoError"!==w.name)throw w;return-w.Pa}},u:function(a){try{return a=z(a),Yb(a),0}catch(b){if("undefined"==typeof X||"ErrnoError"!==b.name)throw b;return-b.Pa}},f:function(a,b){try{return a=z(a),mc(b,Zb(a))}catch(c){if("undefined"==typeof X||"ErrnoError"!==c.name)throw c;return-c.Pa}},r:function(a,b,c){try{b=z(b);b=Y(a,b);if(c)if(512===c)Yb(b);else return-28;else ua(b);return 0}catch(d){if("undefined"==typeof X||"ErrnoError"!==d.name)throw d;
return-d.Pa}},q:function(a,b,c){try{b=z(b);b=Y(a,b,!0);var d=Date.now(),e,g;if(c){var h=F[c>>2]+4294967296*E[c+4>>2],q=E[c+8>>2];1073741823==q?e=d:1073741822==q?e=null:e=1E3*h+q/1E6;c+=16;h=F[c>>2]+4294967296*E[c+4>>2];q=E[c+8>>2];1073741823==q?g=d:1073741822==q?g=null:g=1E3*h+q/1E6}else g=e=d;if(null!==(g??e)){a=e;var w=S(b,{$a:!0}).node;Qb(w.La.Ua)(w,{atime:a,mtime:g})}return 0}catch(t){if("undefined"==typeof X||"ErrnoError"!==t.name)throw t;return-t.Pa}},m:()=>Ma(""),l:()=>{Ya=!1;Hc=0},A:function(a,
b){a=-9007199254740992>a||9007199254740992<a?NaN:Number(a);a=new Date(1E3*a);E[b>>2]=a.getSeconds();E[b+4>>2]=a.getMinutes();E[b+8>>2]=a.getHours();E[b+12>>2]=a.getDate();E[b+16>>2]=a.getMonth();E[b+20>>2]=a.getFullYear()-1900;E[b+24>>2]=a.getDay();var c=a.getFullYear();E[b+28>>2]=(0!==c%4||0===c%100&&0!==c%400?Jc:Ic)[a.getMonth()]+a.getDate()-1|0;E[b+36>>2]=-(60*a.getTimezoneOffset());c=(new Date(a.getFullYear(),6,1)).getTimezoneOffset();var d=(new Date(a.getFullYear(),0,1)).getTimezoneOffset();
E[b+32>>2]=(c!=d&&a.getTimezoneOffset()==Math.min(d,c))|0},y:function(a,b,c,d,e,g,h){e=-9007199254740992>e||9007199254740992<e?NaN:Number(e);try{var q=T(d);if(0!==(b&2)&&0===(c&2)&&2!==(q.flags&2097155))throw new N(2);if(1===(q.flags&2097155))throw new N(2);if(!q.Ma.ib)throw new N(43);if(!a)throw new N(28);var w=q.Ma.ib(q,a,e,b,c);var t=w.Kb;E[g>>2]=w.Ab;F[h>>2]=t;return 0}catch(x){if("undefined"==typeof X||"ErrnoError"!==x.name)throw x;return-x.Pa}},z:function(a,b,c,d,e,g){g=-9007199254740992>g||
9007199254740992<g?NaN:Number(g);try{var h=T(e);if(c&2){c=g;if(32768!==(h.node.mode&61440))throw new N(43);if(!(d&2)){var q=C.slice(a,a+b);h.Ma.jb&&h.Ma.jb(h,q,c,b,d)}}}catch(w){if("undefined"==typeof X||"ErrnoError"!==w.name)throw w;return-w.Pa}},n:(a,b)=>{Kc[a]&&(clearTimeout(Kc[a].id),delete Kc[a]);if(!b)return 0;var c=setTimeout(()=>{delete Kc[a];Mc(()=>Wc(a,performance.now()))},b);Kc[a]={id:c,Xb:b};return 0},B:(a,b,c,d)=>{var e=(new Date).getFullYear(),g=(new Date(e,0,1)).getTimezoneOffset();
e=(new Date(e,6,1)).getTimezoneOffset();F[a>>2]=60*Math.max(g,e);E[b>>2]=Number(g!=e);b=h=>{var q=Math.abs(h);return`UTC${0<=h?"-":"+"}${String(Math.floor(q/60)).padStart(2,"0")}${String(q%60).padStart(2,"0")}`};a=b(g);b=b(e);e<g?(M(a,C,c,17),M(b,C,d,17)):(M(a,C,d,17),M(b,C,c,17))},d:()=>Date.now(),s:()=>2147483648,c:()=>performance.now(),o:a=>{var b=C.length;a>>>=0;if(2147483648<a)return!1;for(var c=1;4>=c;c*=2){var d=b*(1+.2/c);d=Math.min(d,a+100663296);a:{d=(Math.min(2147483648,65536*Math.ceil(Math.max(a,
d)/65536))-La.buffer.byteLength+65535)/65536|0;try{La.grow(d);Ka();var e=1;break a}catch(g){}e=void 0}if(e)return!0}return!1},E:(a,b)=>{var c=0,d=0,e;for(e of Pc()){var g=b+c;F[a+d>>2]=g;c+=M(e,C,g,Infinity)+1;d+=4}return 0},F:(a,b)=>{var c=Pc();F[a>>2]=c.length;a=0;for(var d of c)a+=ib(d)+1;F[b>>2]=a;return 0},e:function(a){try{var b=T(a);oa(b);return 0}catch(c){if("undefined"==typeof X||"ErrnoError"!==c.name)throw c;return c.Pa}},p:function(a,b){try{var c=T(a);m[b]=c.tty?2:P(c.mode)?3:40960===(c.mode&
61440)?7:4;Ha[b+2>>1]=0;G[b+8>>3]=BigInt(0);G[b+16>>3]=BigInt(0);return 0}catch(d){if("undefined"==typeof X||"ErrnoError"!==d.name)throw d;return d.Pa}},w:function(a,b,c,d){try{a:{var e=T(a);a=b;for(var g,h=b=0;h<c;h++){var q=F[a>>2],w=F[a+4>>2];a+=8;var t=cc(e,m,q,w,g);if(0>t){var x=-1;break a}b+=t;if(t<w)break;"undefined"!=typeof g&&(g+=t)}x=b}F[d>>2]=x;return 0}catch(D){if("undefined"==typeof X||"ErrnoError"!==D.name)throw D;return D.Pa}},D:function(a,b,c,d){b=-9007199254740992>b||9007199254740992<
b?NaN:Number(b);try{if(isNaN(b))return 61;var e=T(a);bc(e,b,c);G[d>>3]=BigInt(e.position);e.pb&&0===b&&0===c&&(e.pb=null);return 0}catch(g){if("undefined"==typeof X||"ErrnoError"!==g.name)throw g;return g.Pa}},I:function(a){try{var b=T(a);return b.Ma?.fsync?.(b)}catch(c){if("undefined"==typeof X||"ErrnoError"!==c.name)throw c;return c.Pa}},t:function(a,b,c,d){try{a:{var e=T(a);a=b;for(var g,h=b=0;h<c;h++){var q=F[a>>2],w=F[a+4>>2];a+=8;var t=na(e,m,q,w,g);if(0>t){var x=-1;break a}b+=t;if(t<w)break;
"undefined"!=typeof g&&(g+=t)}x=b}F[d>>2]=x;return 0}catch(D){if("undefined"==typeof X||"ErrnoError"!==D.name)throw D;return D.Pa}},k:Lc};
function Yc(){function a(){k.calledRun=!0;if(!Fa){if(!k.noFSInit&&!Gb){var b,c;Gb=!0;b??=k.stdin;c??=k.stdout;d??=k.stderr;b?W("stdin",b):Xb("/dev/tty","/dev/stdin");c?W("stdout",null,c):Xb("/dev/tty","/dev/stdout");d?W("stderr",null,d):Xb("/dev/tty1","/dev/stderr");ma("/dev/stdin",0);ma("/dev/stdout",1);ma("/dev/stderr",1)}Zc.N();Hb=!1;k.onRuntimeInitialized?.();if(k.postRun)for("function"==typeof k.postRun&&(k.postRun=[k.postRun]);k.postRun.length;){var d=k.postRun.shift();Ua.push(d)}Ta(Ua)}}if(0<
J)Xa=Yc;else{if(k.preRun)for("function"==typeof k.preRun&&(k.preRun=[k.preRun]);k.preRun.length;)Wa();Ta(Va);0<J?Xa=Yc:k.setStatus?(k.setStatus("Running..."),setTimeout(()=>{setTimeout(()=>k.setStatus(""),1);a()},1)):a()}}var Zc;
(async function(){function a(c){c=Zc=c.exports;k._sqlite3_free=c.P;k._sqlite3_value_text=c.Q;k._sqlite3_prepare_v2=c.R;k._sqlite3_step=c.S;k._sqlite3_reset=c.T;k._sqlite3_exec=c.U;k._sqlite3_finalize=c.V;k._sqlite3_column_name=c.W;k._sqlite3_column_text=c.X;k._sqlite3_column_type=c.Y;k._sqlite3_errmsg=c.Z;k._sqlite3_clear_bindings=c._;k._sqlite3_value_blob=c.$;k._sqlite3_value_bytes=c.aa;k._sqlite3_value_double=c.ba;k._sqlite3_value_int=c.ca;k._sqlite3_value_type=c.da;k._sqlite3_result_blob=c.ea;
k._sqlite3_result_double=c.fa;k._sqlite3_result_error=c.ga;k._sqlite3_result_int=c.ha;k._sqlite3_result_int64=c.ia;k._sqlite3_result_null=c.ja;k._sqlite3_result_text=c.ka;k._sqlite3_aggregate_context=c.la;k._sqlite3_column_count=c.ma;k._sqlite3_data_count=c.na;k._sqlite3_column_blob=c.oa;k._sqlite3_column_bytes=c.pa;k._sqlite3_column_double=c.qa;k._sqlite3_bind_blob=c.ra;k._sqlite3_bind_double=c.sa;k._sqlite3_bind_int=c.ta;k._sqlite3_bind_text=c.ua;k._sqlite3_bind_parameter_index=c.va;k._sqlite3_sql=
c.wa;k._sqlite3_normalized_sql=c.xa;k._sqlite3_changes=c.ya;k._sqlite3_close_v2=c.za;k._sqlite3_create_function_v2=c.Aa;k._sqlite3_update_hook=c.Ba;k._sqlite3_open=c.Ca;da=k._malloc=c.Da;ea=k._free=c.Ea;k._RegisterExtensionFunctions=c.Fa;Bb=c.Ga;Wc=c.Ha;ra=c.Ia;y=c.Ja;pa=c.Ka;La=c.M;Z=c.O;Ka();J--;k.monitorRunDependencies?.(J);0==J&&Xa&&(c=Xa,Xa=null,c());return Zc}J++;k.monitorRunDependencies?.(J);var b={a:Xc};if(k.instantiateWasm)return new Promise(c=>{k.instantiateWasm(b,(d,e)=>{c(a(d,e))})});
Na??=k.locateFile?k.locateFile("sql-wasm.wasm",za):za+"sql-wasm.wasm";return a((await Ra(b)).instance)})();Yc();


        // The shell-pre.js and emcc-generated code goes above
        return Module;
    }); // The end of the promise being returned

  return initSqlJsPromise;
} // The end of our initSqlJs function

// This bit below is copied almost exactly from what you get when you use the MODULARIZE=1 flag with emcc
// However, we don't want to use the emcc modularization. See shell-pre.js
if (typeof exports === 'object' && typeof module === 'object'){
    module.exports = initSqlJs;
    // This will allow the module to be used in ES6 or CommonJS
    module.exports.default = initSqlJs;
}
else if (typeof define === 'function' && define['amd']) {
    define([], function() { return initSqlJs; });
}
else if (typeof exports === 'object'){
    exports["Module"] = initSqlJs;
}
/* global initSqlJs */
/* eslint no-restricted-globals: ["error"] */

"use strict";

var db;

function onModuleReady(SQL) {
    function createDb(data) {
        if (db != null) db.close();
        db = new SQL.Database(data);
        return db;
    }

    var buff; var data; var result;
    data = this["data"];
    var config = data["config"] ? data["config"] : {};
    switch (data && data["action"]) {
        case "open":
            buff = data["buffer"];
            createDb(buff && new Uint8Array(buff));
            return postMessage({
                id: data["id"],
                ready: true
            });
        case "exec":
            if (db === null) {
                createDb();
            }
            if (!data["sql"]) {
                throw "exec: Missing query string";
            }
            return postMessage({
                id: data["id"],
                results: db.exec(data["sql"], data["params"], config)
            });
        case "getRowsModified":
            return postMessage({
                id: data["id"],
                rowsModified: db.getRowsModified()
            });
        case "each":
            if (db === null) {
                createDb();
            }
            var callback = function callback(row) {
                return postMessage({
                    id: data["id"],
                    row: row,
                    finished: false
                });
            };
            var done = function done() {
                return postMessage({
                    id: data["id"],
                    finished: true
                });
            };
            return db.each(data["sql"], data["params"], callback, done, config);
        case "export":
            buff = db["export"]();
            result = {
                id: data["id"],
                buffer: buff
            };
            try {
                return postMessage(result, [result]);
            } catch (error) {
                return postMessage(result);
            }
        case "close":
            if (db) {
                db.close();
            }
            return postMessage({
                id: data["id"]
            });
        default:
            throw new Error("Invalid action : " + (data && data["action"]));
    }
}

function onError(err) {
    return postMessage({
        id: this["data"]["id"],
        error: err["message"]
    });
}

db = null;
var sqlModuleReady = initSqlJs();

function global_sqljs_message_handler(event) {
    return sqlModuleReady
        .then(onModuleReady.bind(event))
        .catch(onError.bind(event));
}

if (typeof importScripts === "function") {
    self.onmessage = global_sqljs_message_handler;
}

if (typeof require === "function") {
    var worker_threads = require("worker_threads");
    var parentPort = worker_threads.parentPort;
    // eslint-disable-next-line no-undef
    globalThis.postMessage = parentPort.postMessage.bind(parentPort);
    parentPort.on("message", function onmessage(data) {
        var event = { data: data };
        global_sqljs_message_handler(event);
    });

    if (typeof process !== "undefined") {
        process.on("uncaughtException", function uncaughtException(err) {
            postMessage({ error: err.message });
        });
        process.on("unhandledRejection", function unhandledRejection(err) {
            postMessage({ error: err.message });
        });
    }
}
