import { EventEmitter } from 'events';
export interface WSMessage {
    type: string;
    payload?: any;
    timestamp?: string;
    id?: string;
    agentId?: string;
    correlationId?: string;
}
export declare class AgentWSClient extends EventEmitter {
    private ws;
    private reconnectTimer;
    private heartbeatTimer;
    private pingTimer;
    private reconnectDelay;
    private maxReconnectDelay;
    private connected;
    private agentId;
    private serverConfig;
    constructor();
    connect(): void;
    private register;
    private handleMessage;
    send(message: WSMessage): void;
    sendMetrics(type: string, data: any): void;
    private startHeartbeat;
    private stopHeartbeat;
    private scheduleReconnect;
    isConnected(): boolean;
    getAgentId(): string | null;
    getServerConfig(): any;
    disconnect(): void;
    /**
     * Reconnect the WebSocket using the current config.server.wsUrl.
     * Call this after updating config.server.wsUrl at runtime (e.g. after
     * WireGuard tunnel is established) to route traffic through the tunnel.
     */
    reconnect(): void;
}
//# sourceMappingURL=client.d.ts.map