import { AgentWSClient } from '../websocket/client';
export interface UpgradeInfo {
    targetVersion: string;
    packageUrl: string;
    checksum: string;
    mandatory: boolean;
    rollbackVersion?: string;
    releaseNotes?: string;
    agentId?: string;
}
export interface UpgradeCommand {
    version: string;
    downloadUrl: string;
    checksum: string;
    mandatory: boolean;
    releaseNotes?: string;
}
export declare class UpgradeService {
    private wsClient;
    private upgrading;
    private pendingUpgrade;
    constructor(wsClient: AgentWSClient);
    handleUpgradeAvailable(info: UpgradeInfo): void;
    handleUpgradeCommand(command: UpgradeCommand | UpgradeInfo): Promise<void>;
    acceptPendingUpgrade(): boolean;
    rejectPendingUpgrade(): boolean;
    getPendingUpgrade(): UpgradeInfo | null;
    isUpgrading(): boolean;
    private performUpgrade;
    private downloadPackage;
    private calculateChecksum;
    private extractPackage;
    private backupCurrent;
    private replaceFiles;
    private copyRecursive;
    private removeRecursive;
    private restartAgent;
    private reportStatus;
    private reportUpgradeResponse;
    getCurrentVersion(): string;
}
//# sourceMappingURL=upgrade.d.ts.map