export interface PingResult {
    target: string;
    sent: number;
    received: number;
    lost: number;
    lossPercent: number;
    minRtt: number;
    avgRtt: number;
    maxRtt: number;
    jitter: number;
    timestamp: string;
    replies: PingReply[];
}
export interface PingReply {
    seq: number;
    ttl: number;
    time: number;
}
export interface MTRResult {
    target: string;
    hopCount: number;
    timestamp: string;
    hops: MTRHop[];
}
export interface MTRHop {
    hop: number;
    host: string;
    ip: string;
    loss: number;
    sent: number;
    received: number;
    best: number;
    avg: number;
    worst: number;
    stdev: number;
}
export declare class ProbeRunner {
    runPing(target: string, count?: number, timeout?: number): Promise<PingResult>;
    private parsePingOutput;
    runMTR(target: string, count?: number, timeout?: number): Promise<MTRResult>;
    private parseMTRJson;
    private runTracerouteWindows;
    private runTracerouteUnix;
}
//# sourceMappingURL=probe-runner.d.ts.map