export interface SystemMetrics {
    cpu: {
        load: number;
        user: number;
        system: number;
        idle: number;
        cores: number[];
        speed: number;
        temperature?: number;
    };
    memory: {
        total: number;
        used: number;
        free: number;
        percent: number;
        swapTotal: number;
        swapUsed: number;
        swapPercent: number;
    };
    disk: DiskInfo[];
    network: NetworkInfo[];
    networkInterfaces?: NetworkInfo[];
    routes?: NetworkRouteInfo[];
    gpu?: GpuInfo[];
    battery?: BatteryInfo;
    uptime: number;
    loadAvg: number[];
}
export interface DiskInfo {
    fs: string;
    type: string;
    size: number;
    used: number;
    available: number;
    percent: number;
    mount: string;
}
export interface NetworkInfo {
    interface: string;
    rxBytes: number;
    txBytes: number;
    rxSec: number;
    txSec: number;
    speed: number;
    operstate: string;
    type: 'ethernet' | 'wifi' | 'vpn' | 'loopback' | 'other';
    vpnType?: 'wireguard' | 'openvpn' | 'ipsec' | 'other';
    ip4?: string;
    ip6?: string;
    mac?: string;
    gateway?: string;
    dnsServers?: string[];
    mtu?: number;
    isInternal?: boolean;
}
export interface NetworkRouteInfo {
    destination: string;
    gateway: string;
    interface: string;
    metric?: number;
    family: 'ipv4' | 'ipv6';
    isDefault?: boolean;
}
export interface GpuInfo {
    model: string;
    vendor: string;
    vram: number;
    temperature?: number;
    utilizationGpu?: number;
    utilizationMemory?: number;
}
export interface BatteryInfo {
    hasBattery: boolean;
    isCharging: boolean;
    percent: number;
    timeRemaining: number;
}
export interface WifiInfo {
    ssid: string;
    bssid: string;
    rssi: number;
    signal_quality: number;
    channel: number;
    frequency: number;
    link_speed_mbps: number;
    tx_rate_mbps: number;
    rx_rate_mbps: number;
    noise: number;
    security: string;
    interface_name: string;
    ip_address: string;
    gateway: string;
    dns_servers: string[];
    connection_type: string;
    phy_link_speed_mbps: number;
    errors: number;
}
export declare class SystemCollector {
    private collecting;
    collect(): Promise<SystemMetrics>;
    collectQuick(): Promise<Partial<SystemMetrics>>;
    collectWifi(): Promise<WifiInfo | null>;
    collectIPAddresses(): Promise<{
        primary: string;
        all: string[];
    }>;
    collectPhysicalNetwork(): Promise<{
        type: string;
        speed: number;
        interface_name: string;
        ip: string;
    } | null>;
    private buildInterfaceRoutes;
    private networkFromIPv4;
}
//# sourceMappingURL=system.d.ts.map