export interface ScanResult {
    scanId: string;
    agentId?: string;
    findings: ScanFinding[];
    summary: ScanSummary;
    error?: string;
}
export interface ScanFinding {
    type: string;
    severity: 'critical' | 'high' | 'medium' | 'low' | 'info';
    host: string;
    port?: number;
    protocol: string;
    service: string;
    banner: string;
    description: string;
    recommendation: string;
}
export interface ScanSummary {
    totalHosts: number;
    totalPorts: number;
    openPorts: number;
    criticalFindings: number;
    highFindings: number;
    mediumFindings: number;
    lowFindings: number;
    infoFindings: number;
    scanDuration: number;
}
export declare class SecurityScanner {
    private scanning;
    /**
     * Check if dependencies are available and install if needed
     */
    ensureDependencies(): Promise<void>;
    /**
     * Parse port range string like "1-1024,3306,3389,8080-8090"
     */
    private parsePorts;
    private ipv4ToInt;
    private intToIpv4;
    private netmaskToPrefix;
    private parseSweepTargets;
    private pingHost;
    runPingSweep(target: string, options?: {
        concurrency?: number;
        timeout?: number;
    }, onProgress?: (progress: number) => void): Promise<{
        aliveHosts: Array<{
            host: string;
            latencyMs: number;
            output: string;
        }>;
        scannedHosts: number;
        scanTime: number;
    }>;
    private discoverNetworkSegments;
    /**
     * Scan a single TCP port
     */
    private scanPort;
    /**
     * Run a port scan against a target
     */
    runPortScan(target: string, portRange?: string, options?: {
        concurrency?: number;
        timeout?: number;
    }, onProgress?: (progress: number) => void): Promise<{
        openPorts: Array<{
            port: number;
            banner: string;
        }>;
        scanTime: number;
    }>;
    private buildSummary;
    /**
     * Run a full security scan
     */
    scan(scanId: string, scanType: string | undefined, target: string, portRange?: string, options?: any, onProgress?: (progress: number) => void): Promise<ScanResult>;
}
//# sourceMappingURL=security-scanner.d.ts.map