export interface ProductivityRecord {
    timestamp: string;
    application: string;
    windowTitle: string;
    category: string;
    productivityScore: 'productive' | 'neutral' | 'unproductive';
    duration: number;
    idle: boolean;
}
export interface ActivityEvent {
    timestamp: string;
    type: string;
    details: any;
}
export interface ScreenshotRecord {
    timestamp: string;
    mimeType: string;
    imageBase64: string;
    width?: number;
    height?: number;
    application?: string;
    windowTitle?: string;
    isForeground: boolean;
}
export declare class ProductivityCollector {
    private currentApp;
    private currentTitle;
    private appStartTime;
    private lastCpuSecByPid;
    private records;
    private events;
    private lastActivityTime;
    private lastIdleState;
    private idleThreshold;
    private segmentDurationMs;
    private productivityRules;
    private trackingMode;
    private trackActiveWindow;
    private trackKeystrokesActivity;
    private trackKeystrokesLog;
    private trackMouseActivity;
    private trackBrowserUrls;
    private trackBrowserTitles;
    private trackNetworkTraffic;
    private trackScreenshots;
    private screenshotIntervalSeconds;
    private lastScreenshotAt;
    private screenshots;
    private privacyAnonUsers;
    private privacyBlurTitles;
    private privacyExcludeUrls;
    /** Called when server pushes a config update with tenant tracking settings */
    applyTrackingConfig(cfg: {
        tracking_mode?: string;
        track_active_window?: number | boolean;
        track_keystrokes_activity?: number | boolean;
        track_keystrokes_log?: number | boolean;
        track_mouse_activity?: number | boolean;
        track_browser_urls?: number | boolean;
        track_browser_titles?: number | boolean;
        track_network_traffic?: number | boolean;
        track_screenshots?: number | boolean;
        screenshot_interval_seconds?: number;
        privacy_anon_users?: number | boolean;
        privacy_blur_titles?: number | boolean;
        privacy_exclude_urls?: number | boolean;
    }): void;
    getTrackingMode(): string;
    isTrackNetworkTraffic(): boolean;
    isTrackBrowserUrls(): boolean;
    isTrackBrowserTitles(): boolean;
    collectActiveWindow(): Promise<void>;
    private getActiveWindow;
    private getActiveWindowWindows;
    /**
     * Parse `tasklist /V /FO CSV /NH` output.
     * Columns: "Image Name","PID","Session Name","Session#","Mem Usage","Status","User Name","CPU Time","Window Title"
     * We pick the row with the highest CPU time among those with a non-N/A window title
     * in an interactive session (Session# > 0).
     */
    private parseTasklistOutput;
    private getActiveWindowMac;
    private getActiveWindowLinux;
    private captureScreenshot;
    private captureScreenshotWindows;
    /**
     * Get user idle time in milliseconds using OS-level APIs.
     * On Windows, uses GetLastInputInfo via PowerShell.
     * This detects mouse/keyboard/touch inactivity at the OS level.
     */
    private getIdleTime;
    private getIdleTimeWindows;
    private getIdleTimeMac;
    private getIdleTimeLinux;
    private categorize;
    private score;
    updateRules(rules: Record<string, 'productive' | 'neutral' | 'unproductive'>): void;
    flushRecords(): ProductivityRecord[];
    flushEvents(): ActivityEvent[];
    flushScreenshots(): ScreenshotRecord[];
    recordIdleEvent(isIdle: boolean): void;
    getLastInputState(): {
        lastActivityTime: number;
        isIdle: boolean;
        idleSinceMs: number;
    };
    recordURLVisit(url: string, title: string, browser: string): void;
}
//# sourceMappingURL=productivity.d.ts.map