export interface TrafficRule {
    id: string;
    name: string;
    layer: 'L3' | 'L4' | 'L7' | 'url';
    action: 'allow' | 'block' | 'log' | 'throttle';
    conditions: RuleCondition[];
    enabled: boolean;
    priority: number;
}
export interface RuleCondition {
    field: string;
    operator: string;
    value: string;
}
export interface URLFilter {
    id: string;
    pattern: string;
    type?: string;
    matchType?: string;
    action?: 'block' | 'allow' | 'log';
    category: string;
    enabled: boolean;
}
export interface ConnectionInfo {
    protocol: string;
    localAddress: string;
    localPort: number;
    peerAddress: string;
    peerPort: number;
    state: string;
    process?: string;
    pid?: number;
}
export declare class NetworkCollector {
    private trafficRules;
    private urlFilters;
    private blockedConnections;
    collectConnections(): Promise<ConnectionInfo[]>;
    collectStats(): Promise<any[]>;
    updateTrafficRules(rules: TrafficRule[]): void;
    updateURLFilters(filters: URLFilter[]): void;
    evaluateConnection(conn: ConnectionInfo): {
        action: string;
        rule?: TrafficRule;
    };
    evaluateURL(url: string): {
        action: string;
        filter?: URLFilter;
        category?: string;
    };
    private matchesUrlFilter;
    private matchesRule;
    private getFieldValue;
    private isInSubnet;
    getBlockedConnections(): any[];
}
//# sourceMappingURL=network.d.ts.map