interface BrowserHistoryEntry {
    url: string;
    title: string;
    domain: string;
    visitTime: string;
    visitDuration: number;
    browser: string;
    visitCount: number;
}
/**
 * Collects browser history from Chrome, Edge, and Firefox local SQLite databases.
 * Works on Windows without a browser extension by reading the browser's own history DB.
 * The DB is locked while the browser is open, so we copy it to a temp location first.
 */
export declare class BrowserHistoryCollector {
    private lastCollectTime;
    private sentUrls;
    private maxSentCache;
    private sqlJsPromise;
    /**
     * Returns an array of profile paths for Chromium-based browsers.
     * Each entry: { browser, historyPath }
     */
    private getChromiumProfiles;
    private getFirefoxProfiles;
    /**
     * Copy browser DB to temp so we don't lock the original.
     * Returns path to temp copy or null if copy fails.
     */
    private safeCopyDb;
    /**
     * Query Chromium history database (Chrome, Edge, Brave, etc.)
     */
    private queryChromiumHistory;
    /**
     * Query Firefox places.sqlite
     */
    private queryFirefoxHistory;
    /**
     * Run a SQLite query using the sqlite3 command-line tool or PowerShell.
     */
    private getSqlJs;
    private runSqliteQuery;
    /**
     * Collect recent browser history entries since last collection.
     */
    collect(): Promise<BrowserHistoryEntry[]>;
}
export {};
//# sourceMappingURL=browser-history.d.ts.map